local t = Def.ActorFrame {};
local curScreen = Var "LoadingScreen";
local curStage = GAMESTATE:GetCurrentStage();
local curStageIndex = GAMESTATE:GetCurrentStageIndex();

t[#t+1] = LoadFont("Common Normal") .. {
		InitCommand=function(self)
			self:horizalign(right):x(SCREEN_CENTER_X-30):y(SCREEN_TOP+78):zoom(0.55):maxwidth(150/0.55):diffuse(color("#F7E16E"))
		end;
		BeginCommand=function(self)
			self:addx(-SCREEN_WIDTH):decelerate(0.6):addx(SCREEN_WIDTH)
		end;	
		OffCommand=function(self)
			self:decelerate(0.6):addx(-SCREEN_WIDTH)
		end;
        SortOrderChangedMessageCommand=function(self) self:playcommand("Set") end;
        ChangedLanguageDisplayMessageCommand=function(self) self:playcommand("Set") end;
        SetCommand=function(self)
               if GAMESTATE:GetSortOrder() then
					self:finishtweening();
                    self:settext(string.upper(SortOrderToLocalizedString(GAMESTATE:GetSortOrder())));
                    self:playcommand("Refresh");
				else
					self:settext("");
					self:playcommand("Refresh");
               end
        end;
};

t[#t+1] = LoadFont("Common Normal") .. {
		InitCommand=function(self)
			self:horizalign(left):x(SCREEN_CENTER_X-290):y(SCREEN_TOP+78):zoom(0.55):diffuse(color("#FFFFFF"))
		end;
		BeginCommand=function(self)
			self:queuecommand("Set")
			self:addx(-SCREEN_WIDTH):decelerate(0.6):addx(SCREEN_WIDTH)
		end;	
		OffCommand=function(self)
			self:decelerate(0.6):addx(-SCREEN_WIDTH)
		end;
        SetCommand=function(self)
			if not GAMESTATE:IsCourseMode() then
				self:settext("&MENULEFT;&MENURIGHT; SORT")
			else
				self:settext("&MENUUP;&MENUDOWN;&MENUUP;&MENUDOWN; SORT")
			end;
		end;
};

if not GAMESTATE:IsCourseMode() then
t[#t+1] = LoadFont("Common Normal") .. {
	InitCommand=function(self)
		self:horizalign(left):x(SCREEN_CENTER_X-302+44):y(SCREEN_TOP+20+30):zoom(0.5):diffuse(color("#F7E16E"))
	end;
	BeginCommand=function(self)
		if SCREENMAN:GetTopScreen() then
			if not string.find(SCREENMAN:GetTopScreen():GetName(),"ScreenEvaluation") then
				curStageIndex = curStageIndex + 1
			end
		end
		self:playcommand("Set")
		self:addx(-SCREEN_WIDTH):decelerate(0.6):addx(SCREEN_WIDTH)
	end;
	SetCommand=function(self)
		if GAMESTATE:GetCurrentCourse() then
			self:settext( curStageIndex+1 .. " / " .. GAMESTATE:GetCurrentCourse():GetEstimatedNumStages() );
		elseif GAMESTATE:IsEventMode() then
			self:settextf(string.upper("Event Stage"));
		else
			self:settextf("%s", ToEnumShortString(curStage) .. " STAGE");
		end;
	end;
	OffCommand=function(self)
		self:decelerate(0.6):addx(-SCREEN_WIDTH)
	end;
};
end;

t[#t+1] = Def.ActorFrame{
	Def.Quad{
		InitCommand=function(self) self:Center():draworder(160):zoomto(SCREEN_WIDTH,SCREEN_HEIGHT):diffuse(color("#000000")):diffusealpha(0) end;
		ShowPressStartForOptionsCommand=function(self) self:decelerate(0.4):diffusealpha(0.75) end;
		ShowEnteringOptionsCommand=function(self) self:decelerate(0.7):diffusealpha(0) end;
		HidePressStartForOptionsCommand=function(self) self:sleep(0.2):decelerate(0.5):diffusealpha(0) end;
	};	
};

t[#t+1] = StandardDecorationFromFileOptional("SongOptions","SongOptionsText") .. {
	ShowPressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsShowCommand");
	ShowEnteringOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsEnterCommand");
	HidePressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsHideCommand");
};

return t;